unit AOScanMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DlsrLib_TLB, OleCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    SRAO: TDriverLINXSR;
    LDD: TDriverLINXLDD;
    cmdInit: TButton;
    cmdStart: TButton;
    lblStatus: TLabel;
    Label2: TLabel;
    txtCH0Volts: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    cboDevNumber: TComboBox;
    Label5: TLabel;
    txtCH1Volts: TEdit;
    procedure cmdInitClick(Sender: TObject);
    procedure cmdStartClick(Sender: TObject);
    procedure ServiceDone(Sender: TObject; var task, device, subsystem,
      mode: Smallint);
    procedure CloseDriver(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    AOdata : OleVariant;  // buffer for the data
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.cmdInitClick(Sender: TObject);
var
i : integer;
tempstr : string;
begin
// give the LDD control the driver name
ldd.Req_DLL_name := 'kpci3100';
ldd.device := cboDevNumber.ItemIndex;  // set your device number here
// fill in driver name above with your driver name
// 'kpci3108' for KPCI-3108 boards
// 'kpci3100' for KPCI-3110 or KPCI-3116 or KPCI-3102 or KPCI-3104
// 'kpci1800' for KPCI-1800HC series boards
// 'kpcaiao' for KPCMCIA multifunction cards
// 'kmb1800' for DAS-1800 series
srao.Req_DLL_name := ldd.Req_DLL_name;
srao.Req_device := ldd.device;
// use LDD control to display full model name
ldd.Refresh;  // get current data for the driver/device
Form1.Caption := 'Polled Analog Output Scan with ' + ldd.Dev_Model;

// initialize the hardware
  SRAO.Req_subsystem := DL_Device;  // entire device needs Initialized
  SRAO.Req_mode := DL_OTHER;
  SRAO.Req_op := DL_Initialize;
  SRAO.Refresh;
  lblStatus.Caption := SRAO.Message;  // display result

  form1.SetFocus;
  cmdStart.Enabled := True;
  cmdInit.Enabled := False;
end;

procedure TForm1.cmdStartClick(Sender: TObject);
var
dummy : Double;
begin
SRAO.Req_op := DL_Start;
SRAO.Req_subsystem := DL_AO;
SRAO.Req_mode := DL_POLLED;

SRAO.Evt_Tim_type:= DL_NULLEvent;
SRAO.Evt_Str_type := DL_Command;
SRAO.Evt_Stp_type := DL_TCEvent;

SRAO.Sel_chan_N := 2;  // a start channel and stop channel
SRAO.Sel_chan_start := 0;  // index same as the channel for us
SRAO.Sel_chan_startGainCode := SRAO.DLGain2Code(-1);
SRAO.Sel_chan_stop := 1;  // if youhave more than 2 channels you can
                         // extend this stop channel, but then the
                         // buffer size, etc must also be extended.
SRAO.Sel_chan_stopGainCode := SRAO.DLGain2Code(-1);

{* Some boards support multi ranges for their analog outputs.

  Boards such as DDA or DAS-1602,etc use switches on the board to make
  the range selection.  Other boards such as KPCI-3108 or DAS-1802AO
  support range selection from the software.

  Some boards, such as KPCI-3102, KPCI-3104, KPCI-3116 and KPCI-3110
  have only a single range, e.g., always -10 to +10.

  To select ranges from software, use the xxxxGainCode
  property.  The DLGain2Code function will convert bipolar
  and unipolar (sign) gains to the corresponding GainCode
  understood by the driver:

  DLGain2Code(-1) : bipolar, gain of 1 --> -10 to + 10
  DLGain2Code(1) : unipolar, gain of 1 --> 0 to + 10
  DLGain2Code(-2) : bipolar, gain of 2 --> -5 to + 5
    }

// allocate a buffer and an array for the AO data
srAO.Sel_buf_N := 1;  // ArrayBufferConvert uses buffers
SRAO.Sel_buf_samples := 2; // one sample for each channel
SRAO.Sel_chan_format := DL_tNative;
// for AO subsystem, need to load the buffer with data
// before starting the operation

AOdata := VarArrayCreate([0,2],VarSingle); // allocate the array
// load AOdata array with voltage data
  AOdata[0] := StrToFloat(txtCH0Volts.Text); // read in from text boxes
  AOdata[1] := StrToFloat(txtCH1Volts.Text);

 {In order to be able to have your program deal in volts and to
   have it work for all possible ranges that the board might be
   configured to use, the code must make use of the ArrayBufferConvert
   method rather than the DLVolts2Code method.

   ArrayBufferConvert will (internally) make use of the LDD to know
   what the max and min voltages are for the channel and will calculate
   the appropriate DAC counts for that range.

   In contrast, the DLVolts2Code method always assumes a -10 to +10
   range.  If your channel is configured for a different range, then
   this method will not necessarily calculate the correct DAC counts
   for the requested voltage.

 *}
// use the Convert method to move data from an array to the buffer
// it also converts the volts to DAC counts scaled for the range
// setting of the channel
dummy := SRAO.ArrayBufferConvert(0,0,2,AOdata,DL_tSINGLE,0,0);
// now just need to issue SRAO.Refresh to start it

SRAO.Refresh;     //perform the task
lblStatus.Caption := 'Started AO with ' + SRAO.Message;
end;

procedure TForm1.ServiceDone(Sender: TObject; var task, device, subsystem,
  mode: Smallint);
begin
     lblStatus.Caption := 'Voltage Value has been written';
end;

procedure TForm1.CloseDriver(Sender: TObject);
begin
// unload the driver for each object
SRAO.Req_DLL_name := '';
LDD.Req_DLL_name := '';
end;

procedure TForm1.FormCreate(Sender: TObject);
var
i : integer;
tempstr : string;
begin
// populate combo box with device numbers based
   for i := 0 to 5
   do begin
   str(i,tempstr);
   cboDevNumber.Items.Add(tempstr);
   end;
   // set combo box equal to first entry
   cboDevNumber.ItemIndex := 0;
end;

end.
